/*
 * Copyright 1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



/* static char* sccsid = "%W%\t%G%\tAmen Zwa, TriloBYTE."; */



/* imgclt.h: image client */



#if !defined(IMGCLT_H)
#define IMGCLT_H

#if !defined(__STDC__)
#define const
#endif



/* default image window dimensions */
#define I_Width		256
#define I_Height	I_Width



/* default image server port number */
#define I_SvrPort	9999

/* client request types */
enum { I_Conn, I_Disconn, I_ImgDim, I_ColRGB, I_ColMap };

/* function called at disconnect time */
typedef void (*IDisconnFunc)(void*);



/* connect to image server; return 0 if ok, -1 if not */
extern int IConnect(const char* svrname, int svrport);

/* disconnect from image server; return 0 if ok, -1 if not */
extern int IDisconnect(void);

/* set function to be called at disconnect time; return previous function */
extern IDisconnFunc ISetDisconnFunc(IDisconnFunc func, void* usrdata);

/* set image dimensions; return 0 if ok, -1 if not */
extern int IDimension(int width, int height);

/* update image with RGB color data; return 0 if ok, -1 if not */
extern int IColorRGB(const unsigned char* r, const unsigned char* g,
    const unsigned char* b, int size);

/* update image with colormap index data; return 0 if ok, -1 if not */
extern int IColorIndex(const unsigned char* c, int size);

/* get data rate (in KB/sec) */
extern float IGetDataRate(void);

/* get frame rate (in fps) */
extern float IGetFrameRate(void);

#endif	/* IMGCLT_H */
