/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "Etc: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// EEtc.h: etc. definitions



#if !defined(EETC_H)
#define EETC_H

#include <stdlib.h>
#include <sys/types.h>



class ERandom;
extern ERandom* randgen;		// random number generator

class ETime;
extern ETime* timemgr;			// time manager
class ETimer;
extern ETimer* timer;			// timer



// do NOT make these inline functions because
// these macros are used in some structure initializations
#define mklong(hi, lo)	((long(hi) << 16) | long(lo))
#define loshort(l)	(short(l & 0x0000FFFF))
#define hishort(l)	(short((l & 0xFFFF0000) >> 16))



const STRLEN = 512;			// string length
const WRDLEN = 80;			// word length

#define NASTR		"N/A"		// not available
#define UNTITLEDSTR	"Untitled"	// untitled



// value range
struct ERange {
    double lo, hi;			// low and high limits
    ERange() { lo = hi = 0.0; }
    ERange(double l, double h) { lo = l; hi = h; }
    char is_inrange(double v) { return (v >= lo  &&  v <= hi); }
};



extern char* strnew(const char* s);

// environment variable manager
struct EEnvironment {
    char* name;				// environment variable name
    char* value;			// environment variable value
    EEnvironment(const char* n) {
	name = strnew(n); value = strnew(getenv(n)); }
    ~EEnvironment() { delete[] name; delete[] value; }
};



// conversion functions
inline double mm2in(double mm) { return mm / 25.4; }
inline double in2mm(double in) { return in * 25.4; }
inline double sec2min(double sec) { return sec / 60.0; }
inline double sec2hr(double sec) { return sec / 3600.0; }
inline double min2sec(double min) { return min * 60.0; }
inline double min2hr(double min) { return min / 60.0; }
inline double hr2min(double hr) { return hr / 60.0; }
inline double hr2sec(double hr) { return hr / 3600.0; }

// byte ordering functions
inline short swap2(short s) { return (s << 8) | (s >> 8); }
extern long swap4(long l);
extern double swap8(double d);

// flag bit manipulation functions
inline void clr_flag(u_long& flag, u_long bit) { flag &= ~bit; }
inline void set_flag(u_long& flag, u_long bit) { flag |= bit; }
inline u_long get_flag(u_long flag, u_long bit) { return flag & bit; }

// etc. functions
extern void get_dirname(const char* p, char* d);
extern void get_filename(const char* p, char* f);
extern char* strnew(const char* s);
#if !defined(BSD43)
extern const char* strptime(const char* t, const char* fmt, struct tm* ts);
#endif

#endif	// EETC_H
