/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "Etc: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// ERandom.h: random number generator



#if !defined(ERANDOM_H)
#define ERANDOM_H

#include <string.h>
#include <time.h>
#include "EEtc.h"



// 48-bit seed
struct ESeed {
    enum { seedsiz = 6 };		// 48-bit seed
    u_char seedbuf[seedsiz];		// seed buffer
    ESeed() {
	memset(seedbuf, 0, seedsiz); *((long*)(seedbuf+2)) = long(time(0)); }
    ESeed(long s) {			// Big Endian [MSB...LSB] = [003210]
	memset(seedbuf, 0, seedsiz); *((long*)(seedbuf+2)) = s; }
    ESeed(u_char* s) { memcpy(seedbuf, s, seedsiz); }
    ESeed(u_short* s) { memcpy(seedbuf, s, seedsiz); }
    u_short* operator()() const { return (u_short*) seedbuf; }
};



// 48-bit random number generator
class ERandom {
    u_short* seedptr;			// pointer to drand48()'s seed buffer
public:
    ERandom() { set_seed(ESeed(time(0))); }
    ERandom(ESeed s) { set_seed(s); }
    void set_seed(ESeed s) { seedptr = seed48(s()); }
    ESeed get_seed() const { return ESeed(seedptr); }
    double get_rand() { return drand48(); }
    double get_rand(ERange r) { return (r.hi - r.lo) * get_rand() + r.lo; }
};

#endif	// ERANDOM_H
