/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// ETime.h: time manager class



#if !defined(ETIME_H)
#define ETIME_H

#include <time.h>
#include "EEtc.h"



#if defined(BSD43)
#define mktime		timelocal
#endif



// month names
extern const char* month_name[];

// month initials
extern const char* month_initial[];

// day names
extern const char* day_name[];

// day initials
extern const char* day_initial[];



// time manager class (one object per application)
class ETime {
    char timetxt[WRDLEN];
public:
    ETime() { timetxt[0] = '\0'; }
    // current time functions
    struct tm get_gmt() const;
    time_t get_time() const { return time(0); }
    struct tm get_tms() const { return time2tms(get_time()); }
    int get_year();
    int get_month();
    int get_julian() const;
    // time conversion functions
    struct tm time2tms(time_t tc) const;
    const char* time2text(time_t tc, const char* fmt=0);
    time_t tms2time(struct tm& ts) const;
    const char* tms2text(struct tm& ts, const char* fmt=0);
    time_t text2time(const char* t, const char* fmt);
    struct tm text2tms(const char* t, const char* fmt);
};



// timer class (one object per application)
struct ETimer {
#if defined(BSD43)
    friend void sigalrm_timer(int, ...);
#elif defined(SVR4)
#if defined(sun)
    friend void sigalrm_timer(int);
#elif defined(__sgi)
    friend void sigalrm_timer(...);
#endif  // sun, __sgi
#endif  // BSD43, SVR4
public:
    ETimer() { }
    int run(long timeout);		// timeout in milliseconds
};

#endif	// ETIME_H
