/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WButton.h:  button classes



#if !defined(WBUTTON_H)
#define WBUTTON_H

#include "WCtl.h"
#include "WFont.h"



class WPushButton : public WCtl {
    void set_value(int) { }
    int get_value() const { return -1; }
public:
    WPushButton(Widget par, const char* s);
    // access functions
    void set_cp_activate(XtCallbackProc c, XtPointer u=0) {
	XtAddCallback(xtwgt, XmNactivateCallback, c, u); }
    void blink();
};



class WDrawnButton : public WPushButton {
protected:
    virtual void init();
    friend void cp_expose_dbtn(Widget w, XtPointer usr, XtPointer wgt);
public:
    Window xwnd;			// X window
    GC dbtngc;				// drawn button graphics context
    WFont font;				// text font
    WDrawnButton(Widget par);
    // access functions
    void clear();
    // event handlers
    virtual void expose() = 0;
    virtual void arm(Boolean armflg) = 0;
};



class WTgl : public WCtl {
    void set_value(int) { }
    int get_value() const { return -1; }
public:
    WTgl(Widget par, const char* s);
    // access functions
    void set_cp_toggle(XtCallbackProc c, XtPointer u=0) {
	XtAddCallback(xtwgt, XmNvalueChangedCallback, c, u); }
    void set_state(Boolean state);
    Boolean get_state() const;
};



class WCheckButton : public WTgl {
public:
    WCheckButton(Widget par, const char* s) : WTgl(par, s) {
	XtVaSetValues(xtwgt, XmNindicatorType, XmN_OF_MANY, 0); }
};



class WRadioButton : public WTgl {
public:
    WRadioButton(Widget par, const char* s) : WTgl(par, s) {
	XtVaSetValues(xtwgt, XmNindicatorType, XmONE_OF_MANY, 0); }
};



// popup item
struct WPopupItem {
    char* name;				// name
    WidgetClass* type;			// type
    char mnemo;				// mnemonic
};



class WPopupButton : public WCtl {
    XtCallbackProc cp;			// callback procedure
    XtPointer usrdata;			// user data passed to callback
    friend void cp_select_ubtn(Widget w, XtPointer usr, XtPointer wgt);
public:
    WPopupButton(Widget par);
    // access functions
    void set_cp_popup(XtCallbackProc c, XtPointer u=0) {
	cp = c; usrdata = u; }
    void add_menu(const WPopupItem* itm);
    void set_font(XmFontList xfl);
    void set_value(int v);
    int get_value() const;
};



class WTglBox : public WWidget {
protected:
    Boolean* state;			// toggle button state vector
    XtCallbackProc cp;			// callback procedure
    XtPointer usrdata;			// user data passed to callback
public:
    WTglBox(const char** svec);
    ~WTglBox() { if (state) delete[] state; }
    void set_state(Boolean* s);
    const Boolean* get_state() const;
};



class WCheckBox : public WTglBox {
    friend void cp_toggle_cbox(Widget w, XtPointer usr, XtPointer wgt);
public:
    WCheckBox(Widget par, const char** svec);
    // access functions
    void set_cp_checkbox(XtCallbackProc c, XtPointer u=0) {
	cp = c; usrdata = u; }
};



class WRadioBox : public WTglBox {
    friend void cp_toggle_rbox(Widget w, XtPointer usr, XtPointer wgt);
public:
    WRadioBox(Widget par, const char** svec);
    // access functions
    void set_cp_radiobox(XtCallbackProc c, XtPointer u=0) {
	cp = c; usrdata = u; }
};

#endif	// WBUTTON_H
