/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WColor.h: color manager class



#if !defined(WCOLOR_H)
#define WCOLOR_H

#include <limits.h>
#include "WEtc.h"



// predefined color names
#define WBlackColor	"Black"
#define WWhiteColor	"White"
#define WRedColor	"Red"
#define WGreenColor	"Green"
#define WBlueColor	"Blue"

// predefined colors (used to reference color table)
enum {
    black_color,	white_color,
    gray_color,		armgray_color,	darkgray_color,	lightgray_color,
    red_color,		green_color,	blue_color,
    numdef_color			// number of predefined colors
};

// color class
struct WColor {
    char cnam[STRLEN];			// color name
    Pixel col;				// index into color look-up table
    Boolean ownflg;			// this color is owned by application
    WColor() {
	strcpy(cnam, WBlackColor);
	col = BlackPixel(display, screen); ownflg = False; }
    WColor(const char* cn) { alloc(cn); }
    WColor(double r, double g, double b);
    ~WColor() { free(); }
    void alloc(const char* cn);
    void free() { if (ownflg) XFreeColors(display, colormap, &col, 1, 0L); }
    u_short scale(double c) {
	return ((c *= USHRT_MAX) > USHRT_MAX) ? USHRT_MAX - 1 : (u_short)c; }
    WColor& operator=(const WColor& c) {
	if (strcmp(c.cnam, cnam)) { free(); alloc(c.cnam); }
	return *this; }
};

#endif	// WCOLOR_H
