/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WContext.h:  application context class



#if !defined(WCONTEXT_H)
#define WCONTEXT_H

#include "WEtc.h"



extern "C" {
int gethostname(char* name, int len);
}



class WMenu;
class WShl;
class WAppShell;
class WWindow;

// application context base class (one object per application)
class WContext {
    XFontStruct *ttlxfs, *subttlxfs, *lblxfs, *txtxfs;
    int alloc_fonttbl();
    int alloc_cursortbl();
    int alloc_colortbl();
    XPoint pos;				// main shell position at start up
    friend void tp_stackoffset(XtPointer, XtIntervalId*);
public:
    WAppShell* appshl;			// application main shell
    WMenu* mainmenu;			// application main menu
    XtAppContext& xtctx;		// Xt application context
    WContext(WAppShell* s, XtAppContext& c);
    ~WContext();
    // window management functions
    void add_window(WWindow* wnd);
    void del_window(WWindow* wnd);
    // environment access functions
    void get_hostname(char* s) const { gethostname(s, WRDLEN); }
    void get_svrvendor(char* s) const { strcpy(s, ServerVendor(display)); }
    void get_svrname(char* s) const { strcpy(s, DisplayString(display)); }
    void get_svrdpi(double* xdpi, double* ydpi);
    // access functions
    void set_mainmenu(WMenu* m) { mainmenu = m; }
    void run() { XtAppMainLoop(xtctx); }
};

#endif	// WCONTEXT_H
