/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WCursor.h: cursor manager class



#if !defined(WCURSOR_H)
#define WCURSOR_H

#include "WEtc.h"



// predefined cursor names
const u_int
    WArrowCursor = XC_left_ptr,
    WCrossCursor = XC_crosshair,
    WHandCursor = XC_hand2,
    WWatchCursor = XC_watch;

// predefined cursors (used to reference cursor table)
enum {
    arrow_cursor, cross_cursor, hand_cursor, watch_cursor,
    numdef_cursor			// number of predefined cursors
};

// two-color cursor class
struct WCursor {
    Cursor xcsr;			// X cursor
    WCursor(u_int csr);
    WCursor(const char* cbit, u_int cw, u_int ch,
	const char* mbit, u_int mw, u_int mh,
	u_int hx, u_int hy, XColor& fg, XColor& bg);
    ~WCursor() { XFreeCursor(display, xcsr); }
};



// cursor area class
struct WCursorArea {
    Window xwnd;			// X window of class InputOnly
    WCursorArea(Window par);
    virtual ~WCursorArea() { }
    // access functions
    virtual void set_geom(const WRect& g);
    virtual WRect get_geom();
    void set_cursor(Cursor xcsr) { XDefineCursor(display, xwnd, xcsr); }
};

#endif	// WCURSOR_H
