/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WDrawingArea.h: drawing area base class



#if !defined(WDRAWINGAREA_H)
#define WDRAWINGAREA_H

#include "WFont.h"
#include "WWidget.h"



class WDrawingArea : public WWidget {
protected:
    WRect or;				// (l,t,r,b) offset values
    int linewdt;			// line thickness
    Boolean drawframeflg;		// draw white area frame flag
    virtual void init();
    void draw_frame();
    friend void cp_resize_da(Widget w, XtPointer usr, XtPointer wgt);
    friend void cp_expose_da(Widget w, XtPointer usr, XtPointer wgt);
    friend void eh_keyboard_da(Widget w, XtPointer, XEvent* evt, Boolean*);
    friend void eh_mouse_da(Widget w, XtPointer, XEvent* evt, Boolean*);
public:
    Window xwnd;			// X window
    GC dagc;				// drawing area graphics context
    WFont font;				// text font
    WRect dr;				// drawable white area
    WDrawingArea(Widget par);
    ~WDrawingArea() { if (dagc) XFreeGC(display, dagc); }
    // access functions
    void set_trackkeyboard() {
	XtAddEventHandler(xtwgt,
	    KeyPressMask | KeyReleaseMask, False, eh_keyboard_da, 0); }
    void set_trackmouse() {
	XtAddEventHandler(xtwgt,
	    ButtonPressMask | ButtonReleaseMask | PointerMotionMask,
	    False, eh_mouse_da, 0); }
    void set_line(GC gc, int wdt, int sty=LineSolid,
	int cap=CapButt, int join=JoinMiter) {
	XSetLineAttributes(display, gc, linewdt=wdt, sty, cap, join); }
    void set_dash(GC gc, const char* d, int n) {
	XSetDashes(display, gc, 0, d, n); }
    void set_clip(const WRect& r);
    void set_offset(const WRect& r);
    void set_drawframe(Boolean frameflg) { drawframeflg = frameflg; }
    virtual void clear() {
	XClearWindow(display, xwnd); if (drawframeflg) draw_frame(); }
    // test functions
    Boolean is_shown() const { return xtwgt && XtIsRealized(xtwgt); }
    // event handlers
    virtual void resize() { }
    virtual void expose() = 0;
    virtual void keyboard(const XKeyEvent* /*evt*/) { }
    virtual void mouse(const XEvent* /*evt*/) { }
};

#endif	// WDRAWINGAREA_H
