/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WEtc.h: etc. definitions



#if !defined(WETC_H)
#define WETC_H

#include <stdlib.h>

#include <X11/Xlib.h>
#include <X11/cursorfont.h>

#include <X11/Intrinsic.h>

#include <X11/Xmu/Drawing.h>

#include <Xm/Xm.h>
#include <Xm/AtomMgr.h>
#include <Xm/Protocols.h>
#include <Xm/MwmUtil.h>
#include <Xm/MainW.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Separator.h>
#include <Xm/Label.h>
#include <Xm/PushB.h>
#include <Xm/ToggleB.h>
#include <Xm/CascadeB.h>
#include <Xm/DrawingA.h>
#include <Xm/DrawnB.h>
#include <Xm/Text.h>
#include <Xm/List.h>
#include <Xm/Scale.h>
#include <Xm/ScrollBar.h>
#include <Xm/ScrolledW.h>
#include <Xm/MessageB.h>
#include <Xm/FileSB.h>

#if defined(NETAUDIO)
extern "C" {
#include <audio/audiolib.h>
#include <audio/soundlib.h>
#include <audio/Xtutil.h>
}
#endif

#include <Etc/Etc.h>



extern Display* display;		// default display
extern int screen;			// default screen

extern Window root_wnd;			// root window
struct WRect;
extern WRect root_rect;			// root window rectangle
extern XPoint stack_off;		// window stacking offset

extern XmFontList* fonttbl;		// font table
extern u_int maxfont;			// maximum fonts in the table

extern Cursor* cursortbl;		// cursor table
extern u_int maxcursor;			// maximum cursors in the table

extern Colormap colormap;		// default colormap
extern u_int colorpln;			// number of display color planes
extern Pixel* colortbl;			// color look-up table
extern Boolean* colorflg;		// owner flag for each color cell
extern u_int maxcolor;			// maximum colors in the table

struct EEnvironment;
extern EEnvironment* homedir;		// user's home directory

#if defined(NETAUDIO)
extern AuServer* audio;			// network audio server
#endif

class WContext;
extern WContext* context;		// application context

extern char* appname;			// application name

extern Arg args[];			// Xt argument vector
extern int argn;			// Xt argument count



#define LIBID		'XWGT'		// widget library ID



// menu bar and scroll bar dimensions
extern int mbar_hgt, sbar_hgt;

// default window position
const short def_wndx = 0, def_wndy = 0;

// best cursor dimension
const u_int best_csrw = 32, best_csrh = 32;



// rectangle used in geometry management
struct WRect {
    Position x, y;			// top-left corner
    Dimension w, h;			// width and height
    WRect() { x = y = w = h = 0; }
    WRect(Position xx, Position yy, Dimension ww, Dimension hh);
    WRect(XRectangle xr);		// convert XRectangle to WRect
    Dimension r() const { return x + w; }
    Dimension b() const { return y + h; }
    Boolean is_inside(XPoint pt) const {
	return pt.x > x && pt.y > y &&
	    pt.x < Position(r()-1) && pt.y < Position(b()-1); }
    XRectangle operator()() const;	// convert WRect to XRectangle
    Boolean operator==(const WRect& r) const {
	return r.x == x && r.y == y && r.w == w && r.h == h; }
    Boolean operator!=(const WRect& r) const { return !operator==(r); }
};



// alarm clock class
class WAlarm {
    XtTimerCallbackProc tp;		// timeout callback procedure
    XtPointer usrdata;			// user data passed to callback
    long timeout;			// timeout in milliseconds
    XtIntervalId id;			// timer ID
public:
    WAlarm() { tp = 0; usrdata = 0; id = 0; }
    ~WAlarm() { stop(); }
    void set_tp_alarm(XtTimerCallbackProc t, XtPointer u=0) {
	stop(); tp = t; usrdata = u; }
    void start(struct tm& ts);
    void stop() { if (id) { XtRemoveTimeOut(id); id = 0; } }
};



// window manager decoration dimensions
extern Widget get_wmshell(Widget w);
extern int reparent_offset(Widget w, XPoint& off);
extern int title_height(Widget w);
extern int resize_height(Widget w);

// misc. functions
extern void* get_usrdata(Widget w);

#endif	// WETC_H
