/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WFont.h: font manager class



#if !defined(WFONT_H)
#define WFONT_H

#include "WEtc.h"



// predefined font names
#define WCourier12n	"-adobe-courier-medium-r-*-*-12-*-*-*-*-*-*-*"
#define WHelvetica12b	"-adobe-helvetica-bold-r-*-*-12-*-*-*-*-*-*-*"
#define WHelvetica12n	"-adobe-helvetica-medium-r-*-*-12-*-*-*-*-*-*-*"
#define WTimes12b	"-adobe-times-bold-r-*-*-12-*-*-*-*-*-*-*"
#define WX6x10		"6x10"
#define WX6x13		"6x13"

// predefined font short names
#define WTitleFont	WHelvetica12b
#define WSubTitleFont	WTimes12b
#define WLabelFont	WHelvetica12n
#define WTextFont	WX6x13

// predefined fonts (used to reference font table)
enum {
    title_font, subtitle_font, label_font, text_font,
    numdef_font				// number of predefined fonts
};

// font class
struct WFont {
    char fnam[STRLEN];			// font name
    XFontStruct* xfs;			// X font
    WFont() { xfs = 0; alloc(WTextFont); }
    WFont(const char* fn) { xfs = 0; alloc(fn); }
    ~WFont() { free(); }
    void alloc(const char* fn);
    void free() { if (xfs) { XFreeFont(display, xfs); xfs = 0; } }
    int ascent() const { return xfs->ascent; }
    int descent() const { return xfs->descent; }
    int width() const {
	return xfs->max_bounds.rbearing - xfs->min_bounds.lbearing; }
    int height() const {
	return xfs->max_bounds.ascent + xfs->max_bounds.descent; }
    XmFontList fontlist() const {
	return XmFontListCreate(xfs, XmFONTLIST_DEFAULT_TAG); }
    Font operator()() const { return xfs->fid; }
    WFont& operator=(const WFont& f) {
	if (strcmp(f.fnam, fnam)) { free(); alloc(f.fnam); }
	return *this; }
};

#endif	// WFONT_H
