/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WImage.h: imaging classes



#if !defined(WIMAGE_H)
#define WIMAGE_H

#include "WDrawingArea.h"



// GIF definitions
#define gif_id		"GIF87a"
const gif_imagesep = 0x2c, gif_cmapmask = 0x80, gif_intmask = 0x40;



// image base class
class WImg : public WDrawingArea {
protected:
    char name[STRLEN];			// image file name
    Colormap cmap;			// colormap
    XColor* hwcol;			// hardware color values
    u_short *r, *g, *b;			// RGB color values
    Pixel bg;				// background color
    Pixel* col;				// colormap
    Boolean* colflg;			// owner flag for each color cell
    XImage *ximg;			// X image
public:
    WImg(Widget par, const char* fn);
    ~WImg();
    virtual int read() = 0;
    virtual int write() = 0;
};



// GIF image class
class WImageGIF : public WImg {
    Dimension rw, rh;			// raw image width and height
    Position toff, loff;		// image top and left offset
    Dimension iw, ih;			// image width and height
    Position px, py;			// pixel position
    // image file
    u_char* raw;			// raw image from .gif file
    int rawsiz;				// raw image size
    u_char* ras;			// raster image
    u_char* opt;			// output image
    u_char *p, c, *rp, rc;
    // image color
    u_short* use;			// color usage vector
    int colsiz;				// colormap size
    int coluse;				// number of colors used
    int depth;				// image depth (bits/pixel)
    int scansiz;			// scanline size (bytes/scanline)
    int pass;				// interlace pass
    // image compression
    int c_siz, c_isiz, c_max;
    int c_clr, c_eof, c_free1, c_free;
    int c_val, c_crt, c_prv, c_fin, c_in, c_out[1025], c_outcnt;
    int c_bitoff, c_bitmask, c_readmask;
    int c_pre[4096], c_suf[4096];
    // GIF flags
    Boolean usecolflg;			// use color flag
    Boolean useintflg;			// use interlace flag
    int rd_code();
    void add_pixel(u_char ndx);
    int alloc_color();
public:
    WImageGIF(Widget par, const char* fn);
    ~WImageGIF();
    int read();
    int write();
    int numcolor() const { return colsiz; }
    void expose();
};

#endif	// WIMAGE_H
