/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WLst.h: list base class



#if !defined(WLST_H)
#define WLST_H

#include "WFcsItm.h"



// list item
struct WListItem : public ESLink {
    int itmpos;				// item position (begins at 0)
    char* itmtxt;			// item text (allocated by XmList)
    WListItem(int p, const char* s) { itmpos = p; itmtxt = (char*) s; }
    ~WListItem() { XtFree(itmtxt); }
};



// single column scrolling list base class
// WLst counts item position beginning at 0.
// In WLst, item position -1 represents last item.
// XmList counts item position beginning at 1.
// In XmList, item position 0 represents last item.
class WLst : public WFcsItm {
protected:
    ESList fcssel;			// selection list in previous focus
    friend void cp_select_lst(Widget w, XtPointer, XtPointer);
public:
    WLst(Widget par);
    ~WLst() { fcssel.free(); }
    // access functions
    void set_extsel(Boolean extflg);
    void set_sel(int pos, Boolean selflg);
    int get_sel(ESList& l);
    void show_sel();
    void hide_sel();
    void app_itm(const char* itmtxt) { ins_itm(-1, itmtxt); }
    void ins_itm(int pos, const char* itmtxt);
    void del_itm(int pos) { XmListDeletePos(xtwgt, pos+1); get_sel(fcssel); }
    void del_all() { XmListDeleteAllItems(xtwgt); get_sel(fcssel); }
    void rep_itm(int pos, const char* itmtxt);
    int get_itm(ESList& l);
    void set_top(int pos) {
	XtVaSetValues(xtwgt, XmNtopItemPosition, pos+1, 0); }
    int get_top() const;
    void set_bot(int pos) { XmListSetBottomPos(xtwgt, pos+1); }
    int get_bot() const { return get_top() + get_numvis(); }
    int get_match(const char* s) const;
    int get_numitm() const;
    int get_numsel() const;
    int get_numvis() const;
    void set_focus();
    void set_focus(Boolean gainflg, Boolean);
    virtual void list_select(XmListCallbackStruct*) { }
    // test functions
    Boolean is_extsel() const;
    Boolean is_inlist(const char* s) const;
    Boolean is_visible(int pos) const {
	return pos >= get_top() && pos <= get_bot(); }
};

#endif	// WLST_H
