/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WMenu.h: menu base class



#if !defined(WMENU_H)
#define WMENU_H

#include "WEtc.h"



// menu item
struct WMenuItem {
    char* name;				// name
    WidgetClass* type;			// type
    char mnemo;				// mnemonic
    char* accel;			// accelerator
    char* acceltxt;			// accelerator text
    long id;				// pulldown menu (hi) & item (lo) ID's
    WMenuItem* prm;			// pullright submenu
};



// menu item ID
struct WMenuItemID : public ESLink {
    Widget itm;				// menu item widget
    long id;				// menu item ID
    WMenuItemID(Widget w, long i) { itm = w; id = i; }
};



class WWindow;

// menu manager
class WMenu {
protected:
    ESList ilst;			// menu item list
public:
    Widget menubar;			// menu bar
    WMenu(Widget par);
    ~WMenu();
    // access functions
    Widget add_menu(const char* name, char mnemo, const WMenuItem* itm,
	Boolean helpflg=0, Widget par=0);
    void enable(long id, Boolean enflg);
    void check(long id, Boolean chkflg);
    virtual void menu_select(long id) = 0;
    virtual void set_state(int) { }
    virtual void add_window(WWindow*) { }
    virtual void del_window(WWindow*) { }
    // test functions
    Boolean is_enabled(long id);
    Boolean is_checked(long id);
};

#endif	// WMENU_H
