/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WShl.h: shell classes



#if !defined(WSHL_H)
#define WSHL_H

#include "WFcsItm.h"
#include "WWidget.h"



// window manager close window protocol
#define WM_DELETE_WINDOW	"WM_DELETE_WINDOW"



class WShl : public WWidget {
protected:
    EDList wlst;			// unnamed static child widget list
    WWidget** wvec;			// child widget vector
    int numwgt;				// number of widgets in the vector
    char ttltxt[STRLEN];		// shell title text
    WRect geom;				// shell geometry
    virtual void init();
    void add_static(WWidget* wgt) { wlst.put(wgt); }
    void add_widget(WWidget* wgt, int i) { if (wvec) wvec[i] = wgt; }
    friend void eh_reparent_shl(Widget w, XtPointer usr,
	XEvent* evt, Boolean* contflg);
    friend void eh_kbd_shl(Widget w, XtPointer usr,
	XEvent* evt, Boolean* contflg);
public:
    WShl(const char* s) { wvec = 0; numwgt = 0; strcpy(ttltxt, s ? s : ""); }
    ~WShl();
    // access functions
    void set_geom(const WRect& g);
    WRect get_geom();
    void set_focus(WFcsItm* fcs) { fcs->set_focus(); }
    WFcsItm* get_focus() const {
	return (WFcsItm*) get_usrdata(XmGetFocusWidget(xtwgt)); }
    virtual void set_title(const char* s) = 0;
    const char* get_title() const { return ttltxt; }
    virtual void set_decoration(long dec, Boolean setflg) = 0;
    virtual void set_function(long fct, Boolean setflg) = 0;
    virtual void set_cp_close(XtCallbackProc c, XtPointer u=0) = 0;
    void raise() {
	XMapRaised(display, xwindow());
	XSetInputFocus(display, xwindow(), RevertToNone, CurrentTime); }
    // test functions
    virtual Boolean is_modal() const = 0;
};



class WIcon;

class WWnd : public WShl {
public:
    WWnd(const char* s) : WShl(s) { }
    // access functions
    void set_title(const char* s) {
	strcpy(ttltxt, s); XtVaSetValues(xtwgt, XmNtitle, ttltxt, 0); }
    void set_decoration(long dec, Boolean setflg);
    void set_function(long fct, Boolean setflg);
    void set_cp_close(XtCallbackProc c, XtPointer u=0);
    void show();
    void hide();
    void set_sizelimit(const WRect& s);
    void set_icon(const WIcon& icn);
    virtual void set_cursor(Cursor csr) {
	// set cursor for the whole window such as watch cursor
	XDefineCursor(display, xwindow(), csr); }
    // test functions
    Boolean is_modal() const { return False; }
    Boolean is_shown() const { return XtIsRealized(xtwgt); }
};



class WAppShell : public WWnd {
public:
    WAppShell(const char* s, int& argc, char** argv,
	XtAppContext& xtctx, String* fbrsrc);
};



class WWindow : public WWnd {
public:
    WWindow(const char* s, Colormap cmap=0);
};



class WDialog : public WShl {
public:
    WDialog(Widget par, const char* s);
    // access functions
    void set_decoration(long dec, Boolean setflg);
    void set_function(long fct, Boolean setflg);
    void set_cp_close(XtCallbackProc c, XtPointer u=0);
    void show();
    void hide();
    void set_title(const char* s) {
	strcpy(ttltxt, s); 
	XtVaSetValues(xtwgt, XtVaTypedArg, XmNdialogTitle,
	    XmRString, ttltxt, strlen(ttltxt)+1, 0); }
    // test functions
    Boolean is_modal() const { return True; }
};



class WDialogMsg : public WDialog {
protected:
    XtCallbackProc cp;			// callback procedure
    XtPointer usrdata;			// user data passed to callback
public:
    WDialogMsg(Widget par);
    // access functions
    void set_message(const char* s) {
	XtVaSetValues(xtwgt, XtVaTypedArg, XmNmessageString,
	    XmRString, s, strlen(s)+1, 0); }
};



class WDialogFile : public WDialog {
protected:
    char* fnam;				// selected file name
    XtCallbackProc cp;			// callback procedure
    XtPointer usrdata;			// user data passed to callback
public:
    WDialogFile(Widget par);
    ~WDialogFile() { if (fnam) XtFree(fnam); }
    // access functions
    const char* get_filename() const { return fnam; }
};



class WDialogQst : public WDialog {
protected:
    XtCallbackProc cp;			// callback procedure
    XtPointer usrdata;			// user data passed to callback
public:
    WDialogQst(Widget par);
    // access functions
    void set_message(const char* s) {
	XtVaSetValues(xtwgt, XtVaTypedArg, XmNmessageString,
	    XmRString, s, strlen(s)+1, 0); }
};

#endif	// WSHL_H
