/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WSound.h: sound manager class



#if defined(NETAUDIO)

#if !defined(WSOUND_H)
#define WSOUND_H

#include "WEtc.h"



// sound base class
struct WSnd {
    char name[STRLEN];			// sound file name
    Sound sound;			// sound header
    WSnd(const char* s);
    virtual ~WSnd() { SoundCloseFile(sound); }
    // access functions
    const char* get_name() const { return name; }
    const char* get_fileformat() const { return SoundFileFormatString(sound); }
    const char* get_dataformat() const { return SoundDataFormatString(sound); }
    int get_size() const { return SoundNumBytes(sound); }
    int get_numtrack() const { return SoundNumTracks(sound); }
    int get_numsample() const { return SoundNumSamples(sound); }
    int get_samplerate() const { return SoundSampleRate(sound); }
    int get_samplesize() const { return SoundBytesPerSample(sound); }
    AuFixedPoint get_volume() const { return AuFixedPointFromSum(1, 0); }
    virtual void play() const = 0;
    // test functions
    Boolean is_connected() const { return audio != 0; }
};



// play sound from file
struct WSoundFile : public WSnd {
    WSoundFile(const char* s) : WSnd(s) { }
    // access functions
    void play() const;
};



// play sound from memory
struct WSoundData : public WSnd {
    char* data;				// sound data
    WSoundData(const char* s);
    ~WSoundData() { if (data) delete[] data; }
    // access functions
    void play() const;
};



// play sound from server bucket
struct WSoundBucket : public WSnd {
    AuBucketID bkt;			// sound bucket ID
    WSoundBucket(const char* s);
    // access functions
    void play() const;
};

#endif	// WSOUND_H

#endif	// NETAUDIO
