/*
 * Copyright 1994-1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "XmWidget: %W%\t%G%\tAmen Zwa, TriloBYTE.";



// WWidget.h: widget base class



#if !defined(WWIDGET_H)
#define WWIDGET_H

#include "WEtc.h"



// abstract base class for all widgets
struct WWidget : public EDLink {
    long libid;				// widget library ID
    Widget xtwgt;			// Xt widget for this widget
    WWidget() { libid = LIBID; xtwgt = 0; }
    virtual ~WWidget() { XtDestroyWidget(xtwgt); }
    // access functions
    virtual void set_geom(const WRect& g);
    virtual WRect get_geom();
    virtual void show() { XtManageChild(xtwgt); }
    virtual void hide() { XtUnmanageChild(xtwgt); }
    void enable(Boolean enflg) { XtSetSensitive(xtwgt, enflg); }
    Window xwindow() const { return XtWindow(xtwgt); }
    // test functions
    virtual Boolean is_shown() const { return xtwgt && XtIsManaged(xtwgt); }
    Boolean is_enabled() const { return xtwgt && XtIsSensitive(xtwgt); }
};

#endif	// WWIDGET_H
