/*
 * Copyright 1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



static char* sccsid = "%W%\t%G%\tAmen Zwa, TriloBYTE.";



// etc.c: etc. definitions for OpenGL image display server



#include <errno.h>
#include "etc.h"
#include "imagewnd.h"



// image window
ImageWnd* imagewnd;

// Error dialog
WError* errdlg;



void cleanup()
{
    if (errdlg) { delete errdlg; errdlg = 0; }
    if (imagewnd) { delete imagewnd; imagewnd = 0; }
}



void error_dialog(const char* s)
{
    if (!errdlg) {
	errdlg = new WError(context->appshl->xtwgt);
	if (!errdlg) {
	    cerr << "Cannot create Error Window.";
	    exit(1);
	}
    }
    if (errdlg) {
	errdlg->set_message(s);
	errdlg->show();
    } else cerr << s << '\n';
}



// read n bytes; return number of bytes remaining, -1 if error
int readn(int fd, void* msg, int siz)
{
    char* tmp = (char*) msg;
    int numleft = siz, numread;
    while (numleft > 0) {
        numread = read(fd, tmp, numleft);
	if (numread == 0) break;	// EOF
	if (numread == -1) return -1;	// error
        numleft -= numread;
        tmp += numread;
    }
    return siz - numleft;
}



// write n bytes; return number of bytes remaining, -1 if error
int writen(int fd, const void* msg, int siz)
{
    char* tmp = (char*) msg;
    int numleft = siz, numwrite;
    while (numleft > 0) {
        numwrite = write(fd, tmp, numleft);
        if (numwrite == -1) return -1;	// error
        numleft -= numwrite;
        tmp += numwrite;
    }
    return siz - numleft;
}
