/*
 * Copyright 1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "%W%\t%G%\tAmen Zwa, TriloBYTE.";



// etc.h: etc. definitions for OpenGL image display server



#if !defined(ETC_H)
#define ETC_H

#include <iostream.h>
#include <strstream.h>
#include <fstream.h>
#include <iomanip.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>
#include <string.h>
#include <limits.h>
#include <float.h>
#include <math.h>
#include <signal.h>

#include <XmWidget/XmWidget.h>
#include <Etc/Etc.h>

#if defined(__sgi)
#include <GL/glx.h>
#include <GL/gl.h>
#endif

#include "imgclt.h"



// image window
class ImageWnd;
extern ImageWnd* imagewnd;

// Error dialog
extern WError* errdlg;



// misc. functions
inline void error(const char* s) { cerr << appname << ": " << s << endl; }
extern void cleanup();

// dialog functions
extern void error_dialog(const char* s);

// network functions
extern int readn(int fd, void* msg, int siz);
extern int writen(int fd, const void* msg, int siz);

#endif	// ETC_H



/*

Conventions Used in this Program
--------------------------------

- Item ID prefixes:
	im_		Menu
	ii_		Image Window



Format of Messages Sent by Server to Client
-------------------------------------------

- disconn
	- Disconnect client connection to the server and exit.
	- Message format:
		{
		I_Disconn [4];
		}
	- Client calls the function:
		int IServerExit();



Format of Messages Sent by Client to Server
-------------------------------------------

- I_Conn
	- Connect client to the server.  No message is sent.
	- Client calls the function:
		int IConnect();

- I_Disconn
	- Disconnect client connection to the server and exit.
	- Message format:
		{
		I_Disconn [4];
		}
	- Client calls the function:
		int IDisconnect();

- I_ImgDim
	- Image dimensions.
	- Message format:
		{
		I_ImgDim [4];
		width [4];
		height [4];
		}
	- Client calls the function:
		int IDimension(int width, int height);

- I_ColRGB
	- RGB image data. Update the image window using this image data.
	- Color is represented as follows.
		colsiz = image_wdt * image_hgt;		// color vector size
		char r[colsiz], g[colsiz], b[colsiz];
	- Message format:
		{
		I_ColRGB [4];
		size [4];		// color vector size
		rdata [size];
		gdata [size];
		bdata [size];
		}
	- Client calls the function:
		int IColorRGB(const char* r, const char* g, const char* b);

- I_ColMap
	- Colormap image data.  Update the image window using this image data.
	- Color is represented as follows.
		ndxsiz = image_wdt * image_hgt;		// image size
		char col[ndxsiz];
	- Message format:
		{
		I_ColMap [4];
		size [4];		// index vector size
		data [size];
		}
	- Client calls the function:
		int IColorIndex(const char* c);

*/
