/*
 * Copyright 1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



// static char* sccsid = "%W%\t%G%\tAmen Zwa, TriloBYTE.";



// imagewnd.h: image window



#if !defined(IMAGEWND_H)
#define IMAGEWND_H

#include "etc.h"



// widget ID's
enum {
    ii_image_da,
    ii_numwgt
};



class Image : public WDrawingArea {
    char* rgbfname;			// RGB color file name
    Pixel* col;				// color indices
    Boolean* ownflg;			// color cell is owned flags
    Pixmap pmap;			// saved image
    WFont ttlfont;			// title font
    int width, height;			// image width and height
    void init();
    u_short scale_color(float rgb) {
	return ((rgb *= USHRT_MAX) > USHRT_MAX) ? USHRT_MAX-1 : u_short(rgb); }
    int alloc_colmap(const char* fn);
public:
    Image(Widget par) : WDrawingArea(par) {
	rgbfname = 0; col = 0; ownflg = 0; pmap = 0;
	width = I_Width; height = I_Height; }
    ~Image();
    void set_rgbfile(const char* fn) { rgbfname = strnew(fn); }
    void clear_text();
    void draw_text(int y, const char* s);
    void draw_image(const u_char* r, const u_char* g, const u_char* b);
    void draw_image(const u_char* c);
    void resize_image(int wdt, int hgt);
    void expose();
};



class ImageWnd : public WWindow {
    Boolean svrflg;			// server is ready flag
    Boolean cltflg;			// client connection is active flag
    int svrport;			// server port number
    int csd, dsd;			// control and data sockets
    XtInputId aipid, dipid;		// input ID for accept and dispatch
    u_char *rvec, *gvec, *bvec, *cvec;	// r, g, b, and color map index vectors
    int conn_client();
    int disconn_client();
    int dispatch();
    int resize_image();
    void decomp_colrgb();
    void decomp_colmap();
    int update_colrgb();
    int update_colmap();
    friend void ip_accept_imagewnd(XtPointer usr, int* sd, XtInputId*);
    friend void ip_dispatch_imagewnd(XtPointer usr, int* sd, XtInputId*);
public:
    ImageWnd(XStandardColormap* stdcmap);
    ~ImageWnd() { disconn_client(); }
    void set_rgbfile(const char* fn) {
	((Image*)wvec[ii_image_da])->set_rgbfile(fn); }
    int start_server(int port);
};

#endif	// IMAGEWND_H
