/*
 * Copyright 1995 TriloBYTE Software Solutions.
 *
 * Author: Amen Zwa, TriloBYTE.
 */



static char* sccsid = "%W%\t%G%\tAmen Zwa, TriloBYTE.";



/* imgclttst.c: image client test */



#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "imgclt.h"



#define NUMFRAME	240
#define STRLEN		80

const char* rotate[] = { "-", "\\", "|", "/" };

static char buf[STRLEN];



static void error(const char* s)
{
    fprintf(stderr, "imgclt: %s\n", s);
}



/* function called after disconnect */
void disconn_func(void* usrdata)
{
    printf("Disconnected from server %s.\n", (char*)usrdata);
}



int main(int argc, char** argv)
{
    char svrname[STRLEN];
    unsigned char *r = 0, *g = 0, *b = 0, *c = 0;
    float col, coldel;
    int i, x, y, wdt, hgt, ndx, size, svrport = I_SvrPort;
    extern char *optarg;

    gethostname(svrname, STRLEN);
    while ((i = getopt(argc, argv, "s:p:h")) != EOF)
	switch (i) {
	case 's':
	    strcpy(svrname, optarg);
	    break;
	case 'p':
	    svrport = atoi(optarg);
	    break;
	case 'h':
	case '?':
	    error("Usage: imgclttst [-s svrname] [-p svrport]");
	    break;
	}

    IConnect(svrname, svrport);
    ISetDisconnFunc(disconn_func, (void*)svrname);
    wdt = I_Width;
    hgt = I_Height;
    if (wdt != I_Width || hgt != I_Height) IDimension(wdt, hgt);
    size = wdt * hgt;
    r = (unsigned char*) calloc(size, sizeof(unsigned char));
    g = (unsigned char*) calloc(size, sizeof(unsigned char));
    b = (unsigned char*) calloc(size, sizeof(unsigned char));
    c = (unsigned char*) calloc(size, sizeof(unsigned char));
/*#define DORGB*/
#if defined(DORGB)
    puts("Generating RGB image...");
    coldel = 1.0 / (float)wdt;
    for (i = 0; i < NUMFRAME; i++) {
	col = 0.0;
	for (x = 0; x < wdt; x++, col += coldel)
	    for (y = 0; y < hgt; y++) {
		ndx = (!(i % 2)) ? x * wdt + y : y * hgt + x;
		r[ndx] = (unsigned char) (col * 128.0);
		g[ndx] = (unsigned char) (col * 128.0);
		b[ndx] = (unsigned char) (col * 255.0);
	    }
	IColorRGB(r, g, b, size);
	if (!(i % 16)) {
	    printf("\t\t%d frames, %.2f KB/sec, %.2f fps\r",
	        IGetNumFrame(), IGetDataRate(), IGetFrameRate());
	}
	printf("\t%s\r", rotate[i % 4]);
	fflush(stdout);
    }
#else
    puts("Generating color mapped image...\n");
    coldel = 1.0 / (float)wdt;
    for (i = 0; i < NUMFRAME; i++) {
	col = 0.0;
	for (x = 0; x < wdt; x++, col += coldel)
	    for (y = 0; y < hgt; y++) {
		ndx = (!(i % 2)) ? x * wdt + y : y * hgt + x;
		c[ndx] = (unsigned char) (col * 128.0);
	    }
	IColorIndex(c, size);
	if (!(i % 16)) {
	    printf("\t\t%d frames, %.2f KB/sec, %.2f fps\r",
	        IGetNumFrame(), IGetDataRate(), IGetFrameRate());
	}
	printf("\t%s\r", rotate[i % 4]);
	fflush(stdout);
    }
#endif
    printf("\t\t%d frames, %.2f KB/sec, %.2f fps\n",
        IGetNumFrame(), IGetDataRate(), IGetFrameRate());
    printf("Press ^D to exit...");
    while (getchar() != EOF) ;
    putchar('\n');
    free(r);
    free(g);
    free(b);
    free(c);
    IDisconnect();
    return 0;
}
